/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ClassFormatException;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Field;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.classfile.Method;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class ClassParser {
    private DataInputStream dataInputStream;
    private final boolean fileOwned;
    private final String fileName;
    private String zipFile;
    private int classNameIndex;
    private int superclassNameIndex;
    private int major;
    private int minor;
    private int accessFlags;
    private int[] interfaces;
    private ConstantPool constantPool;
    private Field[] fields;
    private Method[] methods;
    private Attribute[] attributes;
    private final boolean isZip;
    private static final int BUFSIZE = 8192;

    public ClassParser(InputStream inputStream, String string) {
        this.fileName = string;
        this.fileOwned = false;
        String string2 = inputStream.getClass().getName();
        this.isZip = string2.startsWith("java.util.zip.") || string2.startsWith("java.util.jar.");
        this.dataInputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(new BufferedInputStream(inputStream, 8192));
    }

    public ClassParser(String string) {
        this.isZip = false;
        this.fileName = string;
        this.fileOwned = true;
    }

    public ClassParser(String string, String string2) {
        this.isZip = true;
        this.fileOwned = true;
        this.zipFile = string;
        this.fileName = string2;
    }

    public JavaClass parse() throws IOException, ClassFormatException {
        ZipFile zipFile = null;
        try {
            if (this.fileOwned) {
                if (this.isZip) {
                    zipFile = new ZipFile(this.zipFile);
                    ZipEntry zipEntry = zipFile.getEntry(this.fileName);
                    if (zipEntry == null) {
                        throw new IOException("File " + this.fileName + " not found");
                    }
                    this.dataInputStream = new DataInputStream(new BufferedInputStream(zipFile.getInputStream(zipEntry), 8192));
                } else {
                    this.dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.fileName), 8192));
                }
            }
            this.readID();
            this.readVersion();
            this.readConstantPool();
            this.readClassInfo();
            this.readInterfaces();
            this.readFields();
            this.readMethods();
            this.readAttributes();
        }
        finally {
            if (this.fileOwned) {
                try {
                    if (this.dataInputStream != null) {
                        this.dataInputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        return new JavaClass(this.classNameIndex, this.superclassNameIndex, this.fileName, this.major, this.minor, this.accessFlags, this.constantPool, this.interfaces, this.fields, this.methods, this.attributes, this.isZip ? (byte)3 : 2);
    }

    private void readAttributes() throws IOException, ClassFormatException {
        int n = this.dataInputStream.readUnsignedShort();
        this.attributes = new Attribute[n];
        for (int i = 0; i < n; ++i) {
            this.attributes[i] = Attribute.readAttribute(this.dataInputStream, this.constantPool);
        }
    }

    private void readClassInfo() throws IOException, ClassFormatException {
        this.accessFlags = this.dataInputStream.readUnsignedShort();
        if ((this.accessFlags & 0x200) != 0) {
            this.accessFlags |= 0x400;
        }
        if ((this.accessFlags & 0x400) != 0 && (this.accessFlags & 0x10) != 0) {
            throw new ClassFormatException("Class " + this.fileName + " can't be both final and abstract");
        }
        this.classNameIndex = this.dataInputStream.readUnsignedShort();
        this.superclassNameIndex = this.dataInputStream.readUnsignedShort();
    }

    private void readConstantPool() throws IOException, ClassFormatException {
        this.constantPool = new ConstantPool(this.dataInputStream);
    }

    private void readFields() throws IOException, ClassFormatException {
        int n = this.dataInputStream.readUnsignedShort();
        this.fields = new Field[n];
        for (int i = 0; i < n; ++i) {
            this.fields[i] = new Field((DataInput)this.dataInputStream, this.constantPool);
        }
    }

    private void readID() throws IOException, ClassFormatException {
        if (this.dataInputStream.readInt() != -889275714) {
            throw new ClassFormatException(this.fileName + " is not a Java .class file");
        }
    }

    private void readInterfaces() throws IOException, ClassFormatException {
        int n = this.dataInputStream.readUnsignedShort();
        this.interfaces = new int[n];
        for (int i = 0; i < n; ++i) {
            this.interfaces[i] = this.dataInputStream.readUnsignedShort();
        }
    }

    private void readMethods() throws IOException, ClassFormatException {
        int n = this.dataInputStream.readUnsignedShort();
        this.methods = new Method[n];
        for (int i = 0; i < n; ++i) {
            this.methods[i] = new Method((DataInput)this.dataInputStream, this.constantPool);
        }
    }

    private void readVersion() throws IOException, ClassFormatException {
        this.minor = this.dataInputStream.readUnsignedShort();
        this.major = this.dataInputStream.readUnsignedShort();
    }
}

