/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantMethodType
extends Constant {
    private int descriptorIndex;

    public ConstantMethodType(ConstantMethodType constantMethodType) {
        this(constantMethodType.getDescriptorIndex());
    }

    ConstantMethodType(DataInput dataInput) throws IOException {
        this(dataInput.readUnsignedShort());
    }

    public ConstantMethodType(int n) {
        super((byte)16);
        this.descriptorIndex = n;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitConstantMethodType(this);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(super.getTag());
        dataOutputStream.writeShort(this.descriptorIndex);
    }

    public int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public void setDescriptorIndex(int n) {
        this.descriptorIndex = n;
    }

    @Override
    public String toString() {
        return super.toString() + "(descriptorIndex = " + this.descriptorIndex + ")";
    }
}

