/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ParameterAnnotationEntry;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class ParameterAnnotations
extends Attribute {
    private ParameterAnnotationEntry[] parameterAnnotationTable;

    ParameterAnnotations(byte by, int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(by, n, n2, (ParameterAnnotationEntry[])null, constantPool);
        int n3 = dataInput.readUnsignedByte();
        this.parameterAnnotationTable = new ParameterAnnotationEntry[n3];
        for (int i = 0; i < n3; ++i) {
            this.parameterAnnotationTable[i] = new ParameterAnnotationEntry(dataInput, constantPool);
        }
    }

    public ParameterAnnotations(byte by, int n, int n2, ParameterAnnotationEntry[] parameterAnnotationEntryArray, ConstantPool constantPool) {
        super(by, n, n2, constantPool);
        this.parameterAnnotationTable = parameterAnnotationEntryArray;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitParameterAnnotation(this);
    }

    public final void setParameterAnnotationTable(ParameterAnnotationEntry[] parameterAnnotationEntryArray) {
        this.parameterAnnotationTable = parameterAnnotationEntryArray;
    }

    public final ParameterAnnotationEntry[] getParameterAnnotationTable() {
        return this.parameterAnnotationTable;
    }

    public ParameterAnnotationEntry[] getParameterAnnotationEntries() {
        return this.parameterAnnotationTable;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeByte(this.parameterAnnotationTable.length);
        for (ParameterAnnotationEntry parameterAnnotationEntry : this.parameterAnnotationTable) {
            parameterAnnotationEntry.dump(dataOutputStream);
        }
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        return (Attribute)this.clone();
    }
}

