/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.SSLProtocolException;
import javax.security.auth.x500.X500Principal;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.Record;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLStringizer;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.Utilities;

final class CertificateAuthoritiesExtension {
    static final HandshakeProducer chNetworkProducer = new CHCertificateAuthoritiesProducer();
    static final SSLExtension.ExtensionConsumer chOnLoadConsumer = new CHCertificateAuthoritiesConsumer();
    static final HandshakeProducer crNetworkProducer = new CRCertificateAuthoritiesProducer();
    static final SSLExtension.ExtensionConsumer crOnLoadConsumer = new CRCertificateAuthoritiesConsumer();
    static final SSLStringizer ssStringizer = new CertificateAuthoritiesStringizer();

    CertificateAuthoritiesExtension() {
    }

    private static final class CHCertificateAuthoritiesConsumer
    implements SSLExtension.ExtensionConsumer {
        private CHCertificateAuthoritiesConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_CERTIFICATE_AUTHORITIES)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable certificate_authorities extension", new Object[0]);
                }
                return;
            }
            CertificateAuthoritiesSpec certificateAuthoritiesSpec = new CertificateAuthoritiesSpec(byteBuffer);
            serverHandshakeContext.peerSupportedAuthorities = certificateAuthoritiesSpec.getAuthorities();
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.CH_CERTIFICATE_AUTHORITIES, certificateAuthoritiesSpec);
        }
    }

    private static final class CHCertificateAuthoritiesProducer
    implements HandshakeProducer {
        private CHCertificateAuthoritiesProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            Object object2;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (!clientHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_CERTIFICATE_AUTHORITIES)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable certificate_authorities extension", new Object[0]);
                }
                return null;
            }
            X509Certificate[] x509CertificateArray = clientHandshakeContext.sslContext.getX509TrustManager().getAcceptedIssuers();
            if (x509CertificateArray.length == 0) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("No available certificate authorities", new Object[0]);
                }
                return null;
            }
            List list = CertificateAuthoritiesSpec.getEncodedAuthorities(x509CertificateArray);
            if (list.isEmpty()) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("The number of CAs exceeds the maximum sizeof the certificate_authorities extension", new Object[0]);
                }
                return null;
            }
            CertificateAuthoritiesSpec certificateAuthoritiesSpec = new CertificateAuthoritiesSpec(list);
            int n = 0;
            for (Object object2 : certificateAuthoritiesSpec.authorities) {
                n += ((byte[])object2).length + 2;
            }
            Object object3 = new byte[n + 2];
            object2 = ByteBuffer.wrap((byte[])object3);
            Record.putInt16((ByteBuffer)object2, n);
            for (byte[] byArray : certificateAuthoritiesSpec.authorities) {
                Record.putBytes16((ByteBuffer)object2, byArray);
            }
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.CH_CERTIFICATE_AUTHORITIES, certificateAuthoritiesSpec);
            return object3;
        }
    }

    private static final class CRCertificateAuthoritiesConsumer
    implements SSLExtension.ExtensionConsumer {
        private CRCertificateAuthoritiesConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (!clientHandshakeContext.sslConfig.isAvailable(SSLExtension.CR_CERTIFICATE_AUTHORITIES)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable certificate_authorities extension", new Object[0]);
                }
                return;
            }
            CertificateAuthoritiesSpec certificateAuthoritiesSpec = new CertificateAuthoritiesSpec(byteBuffer);
            clientHandshakeContext.peerSupportedAuthorities = certificateAuthoritiesSpec.getAuthorities();
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.CR_CERTIFICATE_AUTHORITIES, certificateAuthoritiesSpec);
        }
    }

    private static final class CRCertificateAuthoritiesProducer
    implements HandshakeProducer {
        private CRCertificateAuthoritiesProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            Object object2;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.CR_CERTIFICATE_AUTHORITIES)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable certificate_authorities extension", new Object[0]);
                }
                return null;
            }
            X509Certificate[] x509CertificateArray = serverHandshakeContext.sslContext.getX509TrustManager().getAcceptedIssuers();
            if (x509CertificateArray.length == 0) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("No available certificate authorities", new Object[0]);
                }
                return null;
            }
            List list = CertificateAuthoritiesSpec.getEncodedAuthorities(x509CertificateArray);
            if (list.isEmpty()) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("Too many certificate authorities to use the certificate_authorities extension", new Object[0]);
                }
                return null;
            }
            CertificateAuthoritiesSpec certificateAuthoritiesSpec = new CertificateAuthoritiesSpec(list);
            int n = 0;
            for (Object object2 : certificateAuthoritiesSpec.authorities) {
                n += ((byte[])object2).length + 2;
            }
            Object object3 = new byte[n + 2];
            object2 = ByteBuffer.wrap((byte[])object3);
            Record.putInt16((ByteBuffer)object2, n);
            for (byte[] byArray : certificateAuthoritiesSpec.authorities) {
                Record.putBytes16((ByteBuffer)object2, byArray);
            }
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.CR_CERTIFICATE_AUTHORITIES, certificateAuthoritiesSpec);
            return object3;
        }
    }

    static final class CertificateAuthoritiesSpec
    implements SSLExtension.SSLExtensionSpec {
        final List<byte[]> authorities;

        private CertificateAuthoritiesSpec(List<byte[]> list) {
            this.authorities = list;
        }

        private CertificateAuthoritiesSpec(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.remaining() < 3) {
                throw new SSLProtocolException("Invalid certificate_authorities extension: insufficient data");
            }
            int n = Record.getInt16(byteBuffer);
            if (n == 0) {
                throw new SSLProtocolException("Invalid certificate_authorities extension: no certificate authorities");
            }
            if (n > byteBuffer.remaining()) {
                throw new SSLProtocolException("Invalid certificate_authorities extension: insufficient data");
            }
            this.authorities = new LinkedList<byte[]>();
            while (n > 0) {
                byte[] byArray = Record.getBytes16(byteBuffer);
                n -= 2 + byArray.length;
                this.authorities.add(byArray);
            }
        }

        private static List<byte[]> getEncodedAuthorities(X509Certificate[] x509CertificateArray) {
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>(x509CertificateArray.length);
            int n = 0;
            for (X509Certificate x509Certificate : x509CertificateArray) {
                X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
                byte[] byArray = x500Principal.getEncoded();
                if ((n += byArray.length) > 65535) {
                    return Collections.emptyList();
                }
                if (byArray.length == 0) continue;
                arrayList.add(byArray);
            }
            return arrayList;
        }

        X500Principal[] getAuthorities() {
            X500Principal[] x500PrincipalArray = new X500Principal[this.authorities.size()];
            int n = 0;
            for (byte[] byArray : this.authorities) {
                x500PrincipalArray[n++] = new X500Principal(byArray);
            }
            return x500PrincipalArray;
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"certificate authorities\": '['\n{0}']'", Locale.ENGLISH);
            StringBuilder stringBuilder = new StringBuilder(512);
            for (byte[] byArray : this.authorities) {
                X500Principal x500Principal = new X500Principal(byArray);
                stringBuilder.append(x500Principal.toString());
                stringBuilder.append("\n");
            }
            Object[] objectArray = new Object[]{Utilities.indent(stringBuilder.toString())};
            return messageFormat.format(objectArray);
        }
    }

    private static final class CertificateAuthoritiesStringizer
    implements SSLStringizer {
        private CertificateAuthoritiesStringizer() {
        }

        @Override
        public String toString(ByteBuffer byteBuffer) {
            try {
                return new CertificateAuthoritiesSpec(byteBuffer).toString();
            }
            catch (IOException iOException) {
                return iOException.getMessage();
            }
        }
    }
}

