/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.compiler.util;

import com.sun.org.apache.xalan.internal.xsltc.compiler.util.Type;
import java.util.ArrayList;
import java.util.List;

public final class MethodType
extends Type {
    private final Type _resultType;
    private final List<Type> _argsType;

    public MethodType(Type type) {
        this._argsType = null;
        this._resultType = type;
    }

    public MethodType(Type type, Type type2) {
        if (type2 != Type.Void) {
            this._argsType = new ArrayList<Type>();
            this._argsType.add(type2);
        } else {
            this._argsType = null;
        }
        this._resultType = type;
    }

    public MethodType(Type type, Type type2, Type type3) {
        this._argsType = new ArrayList<Type>(2);
        this._argsType.add(type2);
        this._argsType.add(type3);
        this._resultType = type;
    }

    public MethodType(Type type, Type type2, Type type3, Type type4) {
        this._argsType = new ArrayList<Type>(3);
        this._argsType.add(type2);
        this._argsType.add(type3);
        this._argsType.add(type4);
        this._resultType = type;
    }

    public MethodType(Type type, List<Type> list) {
        this._resultType = type;
        this._argsType = list.size() > 0 ? list : null;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("method{");
        if (this._argsType != null) {
            int n = this._argsType.size();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(this._argsType.get(i));
                if (i == n - 1) continue;
                stringBuffer.append(',');
            }
        } else {
            stringBuffer.append("void");
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    @Override
    public String toSignature() {
        return this.toSignature("");
    }

    public String toSignature(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        if (this._argsType != null) {
            int n = this._argsType.size();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(this._argsType.get(i).toSignature());
            }
        }
        return stringBuffer.append(string).append(')').append(this._resultType.toSignature()).toString();
    }

    @Override
    public com.sun.org.apache.bcel.internal.generic.Type toJCType() {
        return null;
    }

    @Override
    public boolean identicalTo(Type type) {
        boolean bl = false;
        if (type instanceof MethodType) {
            MethodType methodType = (MethodType)type;
            if (this._resultType.identicalTo(methodType._resultType)) {
                int n = this.argsCount();
                bl = n == methodType.argsCount();
                for (int i = 0; i < n && bl; ++i) {
                    Type type2 = this._argsType.get(i);
                    Type type3 = methodType._argsType.get(i);
                    bl = type2.identicalTo(type3);
                }
            }
        }
        return bl;
    }

    @Override
    public int distanceTo(Type type) {
        int n = Integer.MAX_VALUE;
        if (type instanceof MethodType) {
            MethodType methodType = (MethodType)type;
            if (this._argsType != null) {
                int n2 = this._argsType.size();
                if (n2 == methodType._argsType.size()) {
                    n = 0;
                    for (int i = 0; i < n2; ++i) {
                        Type type2;
                        Type type3 = this._argsType.get(i);
                        int n3 = type3.distanceTo(type2 = methodType._argsType.get(i));
                        if (n3 == Integer.MAX_VALUE) {
                            n = n3;
                            break;
                        }
                        n += type3.distanceTo(type2);
                    }
                }
            } else if (methodType._argsType == null) {
                n = 0;
            }
        }
        return n;
    }

    public Type resultType() {
        return this._resultType;
    }

    public List<Type> argsType() {
        return this._argsType;
    }

    public int argsCount() {
        return this._argsType == null ? 0 : this._argsType.size();
    }
}

