/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.compiler;

import com.sun.org.apache.xalan.internal.res.XSLMessages;
import com.sun.org.apache.xml.internal.utils.PrefixResolver;
import com.sun.org.apache.xpath.internal.compiler.Compiler;
import com.sun.org.apache.xpath.internal.compiler.Keywords;
import com.sun.org.apache.xpath.internal.compiler.OpMapVector;
import com.sun.org.apache.xpath.internal.compiler.Token;
import com.sun.org.apache.xpath.internal.compiler.XPathParser;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import jdk.xml.internal.XMLSecurityManager;

class Lexer {
    private Compiler m_compiler;
    PrefixResolver m_namespaceContext;
    XPathParser m_processor;
    static final int TARGETEXTRA = 10000;
    private int[] m_patternMap = new int[100];
    private int m_patternMapSize;
    XMLSecurityManager m_xmlSecMgr;
    private int m_opCountLimit;
    private int m_grpCountLimit;
    private int m_opCount;
    private int m_grpCount;
    private boolean isLiteral = false;

    Lexer(Compiler compiler, PrefixResolver prefixResolver, XPathParser xPathParser, XMLSecurityManager xMLSecurityManager) {
        this.m_compiler = compiler;
        this.m_namespaceContext = prefixResolver;
        this.m_processor = xPathParser;
        this.m_xmlSecMgr = xMLSecurityManager;
        this.m_opCountLimit = xMLSecurityManager != null ? xMLSecurityManager.getLimit(XMLSecurityManager.Limit.XPATH_OP_LIMIT) : 0;
        this.m_grpCountLimit = xMLSecurityManager != null ? xMLSecurityManager.getLimit(XMLSecurityManager.Limit.XPATH_GROUP_LIMIT) : 0;
    }

    void tokenize(String string) throws TransformerException {
        this.tokenize(string, null);
    }

    void tokenize(String string, Vector vector) throws TransformerException {
        boolean bl = false;
        this.m_compiler.m_currentPattern = string;
        this.m_patternMapSize = 0;
        this.m_compiler.m_opMap = new OpMapVector(2500, 2500, 1);
        int n = string.length();
        int n2 = -1;
        int n3 = -1;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    if (n2 != -1) {
                        bl4 = false;
                        bl2 = this.mapPatternElemPos(n4, bl2, bl3);
                        bl3 = false;
                        if (-1 != n3) {
                            n3 = this.mapNSTokens(string, n2, n3, i);
                        } else {
                            this.addToTokenQueue(string.substring(n2, i));
                        }
                    }
                    n2 = i++;
                    while (i < n && (c = string.charAt(i)) != '\"') {
                        ++i;
                    }
                    if (c == '\"' && i < n) {
                        this.addToTokenQueue(string.substring(n2, i + 1));
                        n2 = -1;
                        break;
                    }
                    this.m_processor.error("ER_EXPECTED_DOUBLE_QUOTE", null);
                    break;
                }
                case '\'': {
                    if (n2 != -1) {
                        bl4 = false;
                        bl2 = this.mapPatternElemPos(n4, bl2, bl3);
                        bl3 = false;
                        if (-1 != n3) {
                            n3 = this.mapNSTokens(string, n2, n3, i);
                        } else {
                            this.addToTokenQueue(string.substring(n2, i));
                        }
                    }
                    n2 = i++;
                    while (i < n && (c = string.charAt(i)) != '\'') {
                        ++i;
                    }
                    if (c == '\'' && i < n) {
                        this.addToTokenQueue(string.substring(n2, i + 1));
                        n2 = -1;
                        break;
                    }
                    this.m_processor.error("ER_EXPECTED_SINGLE_QUOTE", null);
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (n2 == -1) break;
                    bl4 = false;
                    bl2 = this.mapPatternElemPos(n4, bl2, bl3);
                    bl3 = false;
                    if (-1 != n3) {
                        n3 = this.mapNSTokens(string, n2, n3, i);
                    } else {
                        String string2 = string.substring(n2, i);
                        if (Token.contains(string2)) {
                            ++this.m_opCount;
                            this.isLiteral = false;
                        }
                        this.addToTokenQueue(string2);
                    }
                    n2 = -1;
                    break;
                }
                case '@': {
                    bl3 = true;
                }
                case '-': {
                    if ('-' == c) {
                        if (!bl4 && n2 != -1) break;
                        bl4 = false;
                    }
                }
                case '!': 
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case '<': 
                case '=': 
                case '>': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '|': {
                    if (n2 != -1) {
                        bl4 = false;
                        bl2 = this.mapPatternElemPos(n4, bl2, bl3);
                        bl3 = false;
                        if (-1 != n3) {
                            n3 = this.mapNSTokens(string, n2, n3, i);
                        } else {
                            this.addToTokenQueue(string.substring(n2, i));
                        }
                        n2 = -1;
                    } else if ('/' == c && bl2) {
                        bl2 = this.mapPatternElemPos(n4, bl2, bl3);
                    } else if ('*' == c) {
                        bl2 = this.mapPatternElemPos(n4, bl2, bl3);
                        bl3 = false;
                    }
                    if (0 == n4 && '|' == c) {
                        if (null != vector) {
                            this.recordTokenString(vector);
                        }
                        bl2 = true;
                    }
                    if (')' == c || ']' == c) {
                        --n4;
                    } else if ('(' == c || '[' == c) {
                        ++n4;
                        if (!this.isLiteral && '(' == c) {
                            ++this.m_grpCount;
                            ++this.m_opCount;
                            this.isLiteral = false;
                        }
                    }
                    if (('>' == c || '<' == c || '=' == c) && '=' != this.peekNext(string, i)) {
                        ++this.m_opCount;
                        this.isLiteral = false;
                    } else if ('(' != c && ')' != c && ']' != c) {
                        ++this.m_opCount;
                        this.isLiteral = false;
                    }
                    this.addToTokenQueue(string.substring(i, i + 1));
                    break;
                }
                case ':': {
                    if (i > 0) {
                        if (n3 == i - 1) {
                            if (n2 != -1 && n2 < i - 1) {
                                this.addToTokenQueue(string.substring(n2, i - 1));
                            }
                            bl4 = false;
                            bl3 = false;
                            n2 = -1;
                            n3 = -1;
                            ++this.m_opCount;
                            this.addToTokenQueue(string.substring(i - 1, i + 1));
                            break;
                        }
                        n3 = i;
                    }
                }
                default: {
                    this.isLiteral = true;
                    if (-1 == n2) {
                        n2 = i;
                        bl4 = Character.isDigit(c);
                        break;
                    }
                    if (!bl4) break;
                    bl4 = Character.isDigit(c);
                }
            }
            if (this.m_grpCountLimit > 0 && this.m_grpCount > this.m_grpCountLimit) {
                throw new TransformerException(XSLMessages.createXPATHMessage("XPATH_GROUP_LIMIT", new Object[]{Integer.toString(this.m_grpCount), Integer.toString(this.m_grpCountLimit), this.m_xmlSecMgr.getStateLiteral(XMLSecurityManager.Limit.XPATH_GROUP_LIMIT)}));
            }
            if (this.m_opCountLimit <= 0 || this.m_opCount <= this.m_opCountLimit) continue;
            throw new TransformerException(XSLMessages.createXPATHMessage("XPATH_OPERATOR_LIMIT", new Object[]{Integer.toString(this.m_opCount), Integer.toString(this.m_opCountLimit), this.m_xmlSecMgr.getStateLiteral(XMLSecurityManager.Limit.XPATH_OP_LIMIT)}));
        }
        if (n2 != -1) {
            bl4 = false;
            bl2 = this.mapPatternElemPos(n4, bl2, bl3);
            if (-1 != n3 || this.m_namespaceContext != null && this.m_namespaceContext.handlesNullPrefixes()) {
                n3 = this.mapNSTokens(string, n2, n3, n);
            } else {
                this.addToTokenQueue(string.substring(n2, n));
            }
        }
        if (0 == this.m_compiler.getTokenQueueSize()) {
            this.m_processor.error("ER_EMPTY_EXPRESSION", null);
        } else if (null != vector) {
            this.recordTokenString(vector);
        }
        this.m_processor.m_queueMark = 0;
    }

    private char peekNext(String string, int n) {
        if (n < 0 || n >= string.length()) {
            throw new IndexOutOfBoundsException("Index " + n + " out of bounds for length " + string.length());
        }
        if (n >= 0 && n < string.length() - 1) {
            return string.charAt(n + 1);
        }
        return '\u0000';
    }

    private boolean mapPatternElemPos(int n, boolean bl, boolean bl2) {
        if (0 == n) {
            if (this.m_patternMapSize >= this.m_patternMap.length) {
                int[] nArray = this.m_patternMap;
                int n2 = this.m_patternMap.length;
                this.m_patternMap = new int[this.m_patternMapSize + 100];
                System.arraycopy(nArray, 0, this.m_patternMap, 0, n2);
            }
            if (!bl) {
                int n3 = this.m_patternMapSize - 1;
                this.m_patternMap[n3] = this.m_patternMap[n3] - 10000;
            }
            this.m_patternMap[this.m_patternMapSize] = this.m_compiler.getTokenQueueSize() - (bl2 ? 1 : 0) + 10000;
            ++this.m_patternMapSize;
            bl = false;
        }
        return bl;
    }

    private int getTokenQueuePosFromMap(int n) {
        int n2 = this.m_patternMap[n];
        return n2 >= 10000 ? n2 - 10000 : n2;
    }

    private final void resetTokenMark(int n) {
        int n2 = this.m_compiler.getTokenQueueSize();
        int n3 = n > 0 ? (n <= n2 ? n - 1 : n) : (this.m_processor.m_queueMark = 0);
        if (this.m_processor.m_queueMark < n2) {
            this.m_processor.m_token = (String)this.m_compiler.getTokenQueue().elementAt(this.m_processor.m_queueMark++);
            this.m_processor.m_tokenChar = this.m_processor.m_token.charAt(0);
        } else {
            this.m_processor.m_token = null;
            this.m_processor.m_tokenChar = '\u0000';
        }
    }

    final int getKeywordToken(String string) {
        int n;
        try {
            Integer n2 = Keywords.getKeyWord(string);
            n = null != n2 ? n2 : 0;
        }
        catch (NullPointerException nullPointerException) {
            n = 0;
        }
        catch (ClassCastException classCastException) {
            n = 0;
        }
        return n;
    }

    private void recordTokenString(Vector vector) {
        int n = this.getTokenQueuePosFromMap(this.m_patternMapSize - 1);
        this.resetTokenMark(n + 1);
        if (this.m_processor.lookahead('(', 1)) {
            int n2 = this.getKeywordToken(this.m_processor.m_token);
            switch (n2) {
                case 1030: {
                    vector.addElement("#comment");
                    break;
                }
                case 1031: {
                    vector.addElement("#text");
                    break;
                }
                case 1033: {
                    vector.addElement("*");
                    break;
                }
                case 35: {
                    vector.addElement("/");
                    break;
                }
                case 36: {
                    vector.addElement("*");
                    break;
                }
                case 1032: {
                    vector.addElement("*");
                    break;
                }
                default: {
                    vector.addElement("*");
                    break;
                }
            }
        } else {
            if (this.m_processor.tokenIs('@')) {
                this.resetTokenMark(++n + 1);
            }
            if (this.m_processor.lookahead(':', 1)) {
                n += 2;
            }
            vector.addElement(this.m_compiler.getTokenQueue().elementAt(n));
        }
    }

    private final void addToTokenQueue(String string) {
        this.m_compiler.getTokenQueue().addElement(string);
    }

    private int mapNSTokens(String string, int n, int n2, int n3) throws TransformerException {
        String string2;
        String string3;
        block9: {
            string3 = "";
            if (n >= 0 && n2 >= 0) {
                string3 = string.substring(n, n2);
            }
            if (null != this.m_namespaceContext && !string3.equals("*") && !string3.equals("xmlns")) {
                try {
                    if (string3.length() > 0) {
                        string2 = this.m_namespaceContext.getNamespaceForPrefix(string3);
                        break block9;
                    }
                    string2 = this.m_namespaceContext.getNamespaceForPrefix(string3);
                }
                catch (ClassCastException classCastException) {
                    string2 = this.m_namespaceContext.getNamespaceForPrefix(string3);
                }
            } else {
                string2 = string3;
            }
        }
        if (null != string2 && string2.length() > 0) {
            this.addToTokenQueue(string2);
            this.addToTokenQueue(":");
            String string4 = string.substring(n2 + 1, n3);
            if (string4.length() > 0) {
                this.addToTokenQueue(string4);
            }
        } else {
            this.m_processor.errorForDOM3("ER_PREFIX_MUST_RESOLVE", new String[]{string3});
        }
        return -1;
    }
}

